implementation module ScrollBars;

import StdClass,StdInt;
import controls;

SetScrollBarValue :: !.Int !Int !Int !*Int -> *Int;
SetScrollBarValue control value max t0
	| max>32767
		= SetScrollBarValue control (value>>1) (max>>1) t0;
		= SetCtlValue control value t0;

GetScrollBarValue :: .Int !Int *Int -> *(Int,*Int);
GetScrollBarValue control max t0
	| max>32767
		= (v<<1,t1); { (v,t1) = GetScrollBarValue control (max>>1) t0; }
		= GetCtlValue control t0;

GetScrollBarMin :: .Int !Int *Int -> *(Int,*Int);
GetScrollBarMin control max t0
	| max>32767
		= (v<<1,t1); { (v,t1) = GetScrollBarMin control (max>>1) t0; }
		= GetCtlMin control t0;

GetScrollBarMax :: .Int !Int *Int -> *(Int,*Int);
GetScrollBarMax control max t0
	| max>32767
		= (v<<1,t1); { (v,t1) = GetScrollBarMax control (max>>1) t0; }
		= GetCtlMax control t0;
